// By EVOLVED
// www.evolved-software.com

//--------------
// un-tweaks
//--------------
   float4x4 ViewProj:ViewProjection;
   float4x4 ViewInv:ViewInverse; 

//--------------
// tweaks
//--------------
   float2 CloudScale[65];
   float3 CloudPosition;
   float2 CloudHeight;
   float3 CloudUv;
   float2 CloudUvScale;
   float2 NoiseUvScale;
   float2 CloudFalloff;
   float3 LightDir1;
   float3 LightDir2;
   float2 CloudCoverage;
   float4 WorleyFbm;

//--------------
// Textures
//--------------
   texture CloudTexture <string Name = "";>;	
   sampler CloudSampler=sampler_state 
      {
 	texture=<CloudTexture>;
      };
   texture CloudNoiseTexture <string Name = "";>;	
   sampler CloudNoiseSampler=sampler_state 
      {
 	texture=<CloudNoiseTexture>;
      };

//--------------
// structs 
//--------------
   struct input
     {
 	float4 Pos:POSITION;
	float3 Normal:NORMAL;
     };
   struct output
     {
	float4 Pos:POSITION;
 	float4 Tex1:TEXCOORD0;
 	float4 Tex2:TEXCOORD1;
	float4 Tex3:TEXCOORD2;
	float4 CloudLayerT:TEXCOORD3;
	float4 CloudLayerB:TEXCOORD4;
	float4 LightLayerT:TEXCOORD5; 
	float4 LightLayerB:TEXCOORD6;
	float4 BlendVec:COLOR0;
	float3 ViewLight:COLOR1;
     };

//--------------
// vertex shader
//--------------
   output VS(input IN) 
     {
 	output OUT;
	float2 CloudSize=CloudScale[IN.Pos.x];
	float2 CloudSz=float2((IN.Pos.y+IN.Pos.z)*CloudSize.x+CloudPosition.y,(IN.Pos.y-IN.Pos.z)*CloudSize.x+CloudPosition.y);
	if(CloudSz.x<CloudHeight.x-CloudHeight.y || CloudSz.y>CloudHeight.x+CloudHeight.y*5) {
	 OUT.Pos=float4(0,0,-100,0);
	 OUT.Tex1=0;
	 OUT.Tex2=0;
	 OUT.Tex3=0;
	 OUT.CloudLayerT=0;
	 OUT.CloudLayerB=0;
	 OUT.LightLayerT=0;
	 OUT.LightLayerB=0;
	 OUT.BlendVec=0;
	 OUT.ViewLight=0;
	} 
	else {
	 float3 NewPos=(IN.Normal*50*CloudSize.x)+CloudPosition;
	 if(NewPos.y<CloudHeight.x-CloudHeight.y) NewPos.y=CloudHeight.x-CloudHeight.y;
	 if(NewPos.y>CloudHeight.x+(CloudHeight.y*5)) NewPos.y=CloudHeight.x+(CloudHeight.y*5);
	 NewPos.xyz +=CloudUv;
	 OUT.Tex1.xy=(NewPos.xz/CloudUvScale);
	 OUT.Tex1.zw=OUT.Tex1.xy*2;
	 OUT.Tex2.xy=OUT.Tex1.xy+(0.075*-LightDir1.xz);
	 OUT.Tex2.zw=(NewPos.xy/NoiseUvScale)+CloudSize.y;
	 OUT.Tex3.xy=(NewPos.zy/NoiseUvScale)+CloudSize.y;
	 OUT.Tex3.zw=(NewPos.xz/NoiseUvScale)+CloudSize.y;
	 NewPos.xyz -=CloudUv;
	 NewPos.y -=CloudHeight.x;
	 OUT.CloudLayerT=NewPos.yyyy-float4(0,CloudHeight.y,CloudHeight.y*2,CloudHeight.y*3);
	 OUT.CloudLayerB=OUT.CloudLayerT-CloudHeight.y;
	 OUT.CloudLayerT /=CloudHeight.y;
	 OUT.CloudLayerB /=CloudHeight.y;
	 OUT.CloudLayerB=1-OUT.CloudLayerB;
	 float CloudShift=(CloudHeight.y*2)-LightDir1.y;
	 NewPos.y +=CloudShift;
	 OUT.LightLayerT=NewPos.yyyy-float4(0,CloudHeight.y,CloudHeight.y*2,CloudHeight.y*3);
	 OUT.LightLayerB=OUT.LightLayerT-CloudHeight.y;
	 OUT.LightLayerT /=CloudHeight.y;
 	 OUT.LightLayerB /=CloudHeight.y;
	 OUT.LightLayerB=1-OUT.LightLayerB;
	 NewPos.y -=CloudShift;
	 NewPos.y +=CloudHeight.x;
	 OUT.BlendVec.w=(NewPos.y/(CloudHeight.y*0.5))*0.75;
	 float3 ViewVec=NewPos.xyz-ViewInv[3].xyz;
	 NewPos.y -=length(ViewVec.xz)/(CloudFalloff*0.0001);
	 OUT.Pos=mul(float4(NewPos,1),ViewProj);
	 float3 ViewVecN=normalize(ViewVec);
	 OUT.BlendVec.xyz=pow(abs(ViewVecN),5);
	 OUT.BlendVec.xyz /=OUT.BlendVec.x+OUT.BlendVec.y+OUT.BlendVec.z;
	 OUT.ViewLight.x=pow(0.5+dot(-LightDir2,ViewVecN)*0.5,8);
	 OUT.ViewLight.y=1-OUT.ViewLight.x;
	 float ViewVecL=length(ViewVec);
	 OUT.ViewLight.z=1-saturate(pow(ViewVecL/CloudFalloff.x,5));
	 OUT.ViewLight.z *=saturate(ViewVecL/CloudFalloff.y);
	}
	return OUT;
     }

//--------------
// pixel shader
//--------------
    float2 Erode(float2 Clouds,float Coverage)
      {
        return (Clouds-(1-Coverage))/Coverage;
      }
    float4 PS(output IN)  : COLOR
     {
	float4 WorleyLayer=saturate(float4(1,IN.CloudLayerT.yzw))*saturate(float4(IN.CloudLayerB.xyz,1));
	float4 Worley=tex2D(CloudNoiseSampler,IN.Tex2.zw)*IN.BlendVec.z+tex2D(CloudNoiseSampler,IN.Tex3.xy)*IN.BlendVec.x+tex2D(CloudNoiseSampler,IN.Tex3.zw)*IN.BlendVec.y;
	float WorleyNoise=dot(Worley,WorleyLayer*WorleyFbm);
	float WorleyEdge=0.1+exp(-dot(1-Worley,WorleyLayer*IN.CloudLayerT.x));
	float2 CloudsLayer=Erode(float2(tex2D(CloudSampler,IN.Tex1.xy).x,tex2D(CloudSampler,IN.Tex2.xy).x),CloudCoverage.x);
	CloudsLayer=saturate(Erode(CloudsLayer,WorleyNoise)*CloudCoverage.y);
	float Clouds=saturate(IN.CloudLayerT.x)*saturate(IN.CloudLayerB.w)*CloudsLayer.x;
	float LightDir=saturate(IN.LightLayerT.x)*saturate(IN.LightLayerB.w)*CloudsLayer.y;
	float2 Lighting=IN.ViewLight.xy*(1.0-pow(1.0-exp(-LightDir.x*IN.BlendVec.w*float2(1.2,0.6)),5.0));
	Clouds=pow(1-exp(-Clouds*IN.BlendVec.w),5.0)*IN.ViewLight.z;
	return float4(Lighting*WorleyEdge,1.0,1.0)*Clouds;
     }
 
//--------------
// techniques   
//--------------
   technique Clouds
      {
 	pass p0
      {		
	vertexShader = compile vs_3_0 VS(); 
 	pixelShader  = compile ps_3_0 PS();
        ColorWriteEnable=7;
	AlphaBlendEnable=TRUE;	
	SrcBlend=One;
	DestBlend=InvSrcAlpha;
	zwriteenable=false;
	cullmode=0;
      }
      }